---
--- Sp_validatesamplewithdnc
---  
--- Validate the entire sample against the DNC list according to the check rules defined in the project installation table.
---  
---Modified 2014-02-26: US1948 - TA13842 DoNotCallList with registration expiration : Voxco.Web: Implement changes in Importation.


IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_validatesamplewithdnc]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_validatesamplewithdnc]
GO


CREATE PROCEDURE [dbo].[Sp_validatesamplewithdnc]
                @projectId INT,
                @userId    INT
AS
	SET nocount  ON

	-- Fetch the DNC Settings from installation table	
	DECLARE @dncFlag int
	SET @dncFlag= (Select top 1 insvalue From Installation where INSSECTION='OPTIONS' and INSIDENT='DNC')
	IF (@dncFlag IS NULL) SET @dncFlag = 1
	IF (@dncFlag = 0) SET @dncFlag = 1   --Always check even if the config say "no check", because the option in DTS import  overide the option in installation table

	DECLARE @dncExpirationPeriod int
	SET @dncExpirationPeriod= (Select top 1 insvalue From Installation where INSSECTION='OPTIONS' and INSIDENT='DNCRegistrationExpiringPeriod')
	IF (@dncExpirationPeriod IS NULL) SET @dncExpirationPeriod = 36

	-- Pre calculate the DNC expiration date
	declare @dncExpirationDate datetime;
	set @dncExpirationDate = DATEADD (month , -@dncExpirationPeriod , GETUTCDATE() )


	-- Fetch the DNC Call result from systemconfig
	DECLARE  @DNCResult VARCHAR(5);
	SELECT   @DNCResult = Rtrim([value]) FROM systemconfig WHERE [name] = 'DoNotCallListResultCode'

	-- Put all DNC respondent into a the @RetiredRespondent temp variable	
	DECLARE  @RetiredRespondent  TABLE( resrespondent VARCHAR(10) )

	INSERT INTO @RetiredRespondent
	SELECT resrespondent
	FROM   respondent JOIN donotcalllist
		   ON resphone = phone
	WHERE	rescompleted = 0 AND
			(	rescoderesult IS NULL OR
				rescoderesult <> @DNCResult )  AND
			( 	( @dncFlag = 1 ) OR 
			    ( @dncFlag = 2 AND donotcalllist.RegistrationDate > @dncExpirationDate )  )

	-- Count the quantity of respondent that are flaged as DNC
	SELECT Count(resrespondent) AS retiredrespondentcount
	FROM   @RetiredRespondent

	-- Create a record in Historic for each respondent decalred as DNC
	INSERT INTO historic
			 (hisrespondent,
			  hiscallnumber,
			  hisinterviewer,
			  hisresult,
			  hiscalldate,
			  histimeslot,
			  hiscallduration,
			  hisdatatype,
			  hisstartquestion,
			  hisendquestion,
			  hismonitoring,
			  hisdialerline,
			  hiswait,
			  hispause,
			  hisfilereference,
			  hispreviouscalldate,
			  projectid,
			  collectmode)
	SELECT resrespondent,
		 Coalesce((SELECT Max(hiscallnumber) + 1
				   FROM   historic
				   WHERE  hisrespondent = resrespondent),1),
		 @userId,
		 @DNCResult,
		 Getutcdate(),
		 0,
		 0,
		 0,
		 '',
		 '',
		 0,
		 0,
		 0,
		 0,
		 '',
		 (SELECT Max(hiscalldate)
		  FROM   historic
		  WHERE  hisrespondent = resrespondent),
		 @projectId,
		 0
	FROM   @RetiredRespondent

	--Update DNC respondents to flag them as DNC
	UPDATE respondent
	SET    rescallbackdate = 0,
		 rescall = 1,
		 rescallcount = rescallcount + 1,
		 rescoderesult = @DNCResult,
		 projectid = @projectId,
		 modifiedby = @userId,
		 modified = Getutcdate()
	FROM   respondent a JOIN @RetiredRespondent b
		   ON a.resrespondent = b.resrespondent 
